<?php
$tempDir = __DIR__ . '/downloads';
$file = isset($_GET['file']) ? basename($_GET['file']) : null;

// Validate filename pattern (yt_VIDEOID_TIMESTAMP.ext)
if (!$file || !preg_match('/^youtube_[a-zA-Z0-9_-]{11}_(audio|\d+p)\.[a-z0-9]+$/', $file)) {
    header("HTTP/1.0 400 Bad Request");
    exit;
}

$filePath = $tempDir . '/' . $file;

if (!file_exists($filePath)) {
    header("HTTP/1.0 404 Not Found");
    exit;
}

// Set appropriate headers
$mimeType = mime_content_type($filePath);
$fileSize = filesize($filePath);

header('Content-Type: ' . $mimeType);
header('Content-Disposition: attachment; filename="' . $file . '"');
header('Content-Length: ' . $fileSize);
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');

// Clean up after download
register_shutdown_function(function() use ($filePath) {
    if (file_exists($filePath)) {
        unlink($filePath);
    }
});

readfile($filePath);
exit;