<?php
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Validate GET request
if ($_SERVER['REQUEST_METHOD'] !== 'GET' || !isset($_GET['url'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'errorMessage' => 'Invalid request']);
    exit;
}

$youtubeUrl = urldecode($_GET['url']);

// Validate YouTube URL
if (!filter_var($youtubeUrl, FILTER_VALIDATE_URL) || !preg_match('/youtu(be\.com|\.be)/', $youtubeUrl)) {
    echo json_encode(['success' => false, 'errorMessage' => 'Please enter a valid YouTube URL']);
    exit;
}

// Extract video ID
preg_match('/(?:youtube\.com\/(?:[^\/]+\/.+\/|(?:v|e(?:mbed)?)\/|.*[?&]v=)|youtu\.be\/)([^"&?\/\s]{11})/', $youtubeUrl, $matches);
$videoId = $matches[1] ?? '';

if (empty($videoId)) {
    echo json_encode(['success' => false, 'errorMessage' => 'Could not extract video ID from URL']);
    exit;
}

// Return success with video ID
echo json_encode([
    'success' => true,
    'videoId' => $videoId,
    'redirectUrl' => 'thankyou.php?url=' . urlencode($youtubeUrl) . '&video_id=' . $videoId
]);