<?php
// Set SEO metadata
$seoTitle = 'Download YouTube Videos Online - Fast & Free | YTDL';
$metaDescription = "Download YouTube videos in MP4, MP3, WEBM and other formats in HD quality. No registration required - fast and free!";
$metaKeywords = "youtube downloader, download youtube videos, youtube to mp4, youtube to mp3, video downloader, hd video download";

// Include header
include 'header.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="<?php echo htmlspecialchars($metaDescription, ENT_QUOTES, 'UTF-8'); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($metaKeywords, ENT_QUOTES, 'UTF-8'); ?>">
    <meta name="robots" content="index, follow">
    <title><?php echo htmlspecialchars($seoTitle, ENT_QUOTES, 'UTF-8'); ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="styles.css">

</head>
<body>
    <div class="main-container">
        <div class="hero-section">
            <h1 class="main-title">YouTube Video Downloader</h1>
            <p class="subtitle">Download videos from YouTube in multiple formats and qualities</p>
            
            <div class="download-form">
                <form id="videoForm" class="url-form">
                    <div class="input-group">
                        <input type="url" name="url" id="youtubeUrl" 
                               placeholder="Paste YouTube URL here..." 
                               required
                               aria-label="YouTube video URL">
                        <button type="submit" class="submit-btn" id="fetchBtn">
                            <i class="fas fa-download"></i> Download
                        </button>
                    </div>
                </form>
                <div class="examples">
                    <p>Example URLs: 
                        <span class="example-url">https://youtube.com/watch?v=VIDEO_ID</span> or 
                        <span class="example-url">https://youtu.be/VIDEO_ID</span>
                    </p>
                </div>
            </div>
        </div>

        <div class="features-section">
            <div class="feature">
                <i class="fas fa-bolt"></i>
                <h3>Fast Downloads</h3>
                <p>Get your videos quickly with our high-speed servers</p>
            </div>
            <div class="feature">
                <i class="fas fa-film"></i>
                <h3>Multiple Formats</h3>
                <p>MP4, MP3, WEBM, 3GP and more formats available</p>
            </div>
            <div class="feature">
                <i class="fas fa-lock"></i>
                <h3>Secure</h3>
                <p>No registration required, completely anonymous</p>
            </div>
        </div>
    </div>

    <div id="resultContainer" class="result-container hidden"></div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.getElementById('videoForm');
            const fetchBtn = document.getElementById('fetchBtn');
            const resultContainer = document.getElementById('resultContainer');
            const originalBtnText = fetchBtn.innerHTML;

            form.addEventListener('submit', async function(event) {
                event.preventDefault();
                
                const youtubeUrl = document.getElementById('youtubeUrl').value.trim();
                if (!youtubeUrl) return;
                
                // Show loading state
                fetchBtn.disabled = true;
                fetchBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing...';
                resultContainer.classList.add('hidden');
                
                try {
                    const response = await fetch('fetch_video.php?url=' + encodeURIComponent(youtubeUrl));
                    const data = await response.json();
                    
                    if (data.success) {
                        window.location.href = 'thankyou.php?url=' + encodeURIComponent(youtubeUrl);
                    } else {
                        resultContainer.innerHTML = `
                            <div class="error-message">
                                <i class="fas fa-exclamation-circle"></i>
                                <p>${data.errorMessage || 'Error processing your request'}</p>
                            </div>
                        `;
                        resultContainer.classList.remove('hidden');
                    }
                } catch (error) {
                    console.error('Error:', error);
                    resultContainer.innerHTML = `
                        <div class="error-message">
                            <i class="fas fa-exclamation-triangle"></i>
                            <p>Network error. Please try again.</p>
                        </div>
                    `;
                    resultContainer.classList.remove('hidden');
                } finally {
                    fetchBtn.disabled = false;
                    fetchBtn.innerHTML = originalBtnText;
                }
            });
        });
    </script>
</body>
</html>