<?php
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Validate POST request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit;
}

// Validate required parameters
$requiredParams = ['url', 'video_id', 'type'];
foreach ($requiredParams as $param) {
    if (!isset($_POST[$param])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'error' => "Missing parameter: $param"]);
        exit;
    }
}

// Sanitize inputs
$videoUrl = filter_var($_POST['url'], FILTER_SANITIZE_URL);
$videoId = filter_var($_POST['video_id'], FILTER_SANITIZE_STRING);
$type = filter_var($_POST['type'], FILTER_SANITIZE_STRING);

// Validate YouTube video ID
if (!preg_match('/^[a-zA-Z0-9_-]{11}$/', $videoId)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Invalid video ID']);
    exit;
}

// For now, return a mock download URL
// In production, implement actual download logic here
echo json_encode([
    'success' => true,
    'downloadUrl' => "https://example.com/download/$videoId." . ($type === 'audio' ? 'mp3' : 'mp4'),
    'message' => 'Download started'
]);

// Actual implementation would use yt-dlp like this:
/*
$tempDir = __DIR__ . '/downloads';
if (!file_exists($tempDir)) {
    mkdir($tempDir, 0755, true);
}

$filename = "video_$videoId." . ($type === 'audio' ? 'mp3' : 'mp4');
$filepath = "$tempDir/$filename";

if ($type === 'audio') {
    exec("yt-dlp -x --audio-format mp3 -o '$filepath' $videoUrl");
} else {
    exec("yt-dlp -f 'bestvideo[ext=mp4]+bestaudio[ext=m4a]/best[ext=mp4]' -o '$filepath' $videoUrl");
}

if (file_exists($filepath)) {
    echo json_encode([
        'success' => true,
        'downloadUrl' => "download_file.php?file=$filename",
        'filename' => $filename
    ]);
} else {
    echo json_encode(['success' => false, 'error' => 'Download failed']);
}
*/