<?php
session_start();

// Check if token is valid
if (!isset($_GET['token']) || !isset($_SESSION['download_token']) || $_GET['token'] !== $_SESSION['download_token']) {
    header("HTTP/1.1 403 Forbidden");
    die("Invalid download token");
}

$videoUrl = $_SESSION['download_url'];
$downloadType = $_SESSION['download_type'];
$quality = $_SESSION['download_quality'];

// Clear the session data
unset($_SESSION['download_token']);
unset($_SESSION['download_url']);
unset($_SESSION['download_type']);
unset($_SESSION['download_quality']);

include 'header.php';
?>

<div class="processing-container">
    <div class="processing-content">
        <div class="spinner">
            <i class="fas fa-spinner fa-spin"></i>
        </div>
        <h2>Preparing Your Download</h2>
        <p>Please wait while we process your request...</p>
        
        <div class="progress-container">
            <div class="progress-bar" id="progressBar"></div>
        </div>
        
        <div id="downloadLink" class="hidden">
            <p>Your download is ready!</p>
            <a href="#" id="actualDownloadLink" class="download-ready-btn">
                <i class="fas fa-download"></i> Click to Download
            </a>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Simulate processing delay
    setTimeout(function() {
        // In a real implementation, this would check with your server
        // to see if the download is ready
        
        // For demo purposes, we'll simulate a successful preparation
        document.getElementById('progressBar').style.width = '100%';
        
        setTimeout(function() {
            document.getElementById('downloadLink').classList.remove('hidden');
            
            // Set up the actual download link
            document.getElementById('actualDownloadLink').addEventListener('click', function(e) {
                e.preventDefault();
                
                // In a real implementation, this would point to your actual download endpoint
                // For now, we'll redirect back with a success message
                window.location.href = 'download_success.php?type=<?php echo $downloadType; ?>';
            });
        }, 500);
    }, 2000);
});
</script>

<style>
.processing-container {
    max-width: 600px;
    margin: 2rem auto;
    padding: 2rem;
    text-align: center;
    background: white;
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.spinner {
    font-size: 3rem;
    color: #4285f4;
    margin-bottom: 1rem;
}

.progress-container {
    width: 100%;
    height: 8px;
    background: #f0f0f0;
    border-radius: 4px;
    margin: 2rem 0;
    overflow: hidden;
}

.progress-bar {
    height: 100%;
    width: 0;
    background: #4285f4;
    transition: width 0.3s ease;
}

.download-ready-btn {
    display: inline-block;
    padding: 0.8rem 1.5rem;
    background: #34a853;
    color: white;
    text-decoration: none;
    border-radius: 4px;
    font-weight: 500;
    margin-top: 1rem;
    transition: background 0.2s ease;
}

.download-ready-btn:hover {
    background: #2d9248;
}

.hidden {
    display: none;
}
</style>

<?php include 'footer.php'; ?>