<?php
$tempDir = __DIR__ . '/temp_downloads';
$file = $_GET['file'] ?? '';

// Validate filename
if (!preg_match('/^video_[a-zA-Z0-9_-]{11}\.(mp4|mp3|webm)$/', $file)) {
    http_response_code(400);
    die('Invalid file request');
}

$filePath = "$tempDir/$file";

if (!file_exists($filePath)) {
    http_response_code(404);
    die('File not found');
}

// Set appropriate headers
$mimeType = mime_content_type($filePath);
$fileSize = filesize($filePath);

header('Content-Type: ' . $mimeType);
header('Content-Disposition: attachment; filename="' . basename($filePath) . '"');
header('Content-Length: ' . $fileSize);
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');

// Clean up after download
register_shutdown_function(function() use ($filePath) {
    if (file_exists($filePath)) {
        unlink($filePath);
    }
});

readfile($filePath);
exit;