<?php
// Error reporting for debugging (remove in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if URL parameter exists
if (!isset($_GET['url'])) {
    header("Location: index.php");
    exit();
}

// Function to extract YouTube video ID
function extractVideoId($url) {
    $pattern = '/^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|&v=)([^#&?]*).*/';
    preg_match($pattern, $url, $matches);
    return (isset($matches[2]) && strlen($matches[2]) === 11) ? $matches[2] : false;
}

$videoUrl = urldecode($_GET['url']);
$videoId = extractVideoId($videoUrl);

// Validate video ID
if (!$videoId) {
    die("Invalid YouTube URL provided");
}

// Generate thumbnail URLs
$thumbnailUrls = [
    'default' => "https://img.youtube.com/vi/$videoId/default.jpg",
    'medium' => "https://img.youtube.com/vi/$videoId/mqdefault.jpg",
    'high' => "https://img.youtube.com/vi/$videoId/hqdefault.jpg",
    'standard' => "https://img.youtube.com/vi/$videoId/sddefault.jpg",
    'maxres' => "https://img.youtube.com/vi/$videoId/maxresdefault.jpg"
];

// Include header
include 'header.php';
?>

<div class="download-container">
    <div class="video-info">
        <div class="thumbnail-container">
            <img src="<?php echo $thumbnailUrls['high']; ?>" 
                 onerror="this.onerror=null;this.src='<?php echo $thumbnailUrls['standard']; ?>';" 
                 alt="Video thumbnail" class="video-thumbnail">
            <div class="thumbnail-overlay">
                <i class="fas fa-play"></i>
            </div>
        </div>
        
        <div class="download-options">
            <h1>Download Options</h1>
            
            <form action="download_video.php" method="post">
                <input type="hidden" name="url" value="<?php echo htmlspecialchars($videoUrl); ?>">
                <input type="hidden" name="video_id" value="<?php echo $videoId; ?>">
                
                <!-- Video Download Options -->
                <div class="option-group">
                    <h2><i class="fas fa-film"></i> Video Downloads</h2>
                    
                    <div class="quality-options">
                        <div class="quality-option">
                            <input type="radio" id="quality-best" name="quality" value="best" checked>
                            <label for="quality-best">
                                <span class="quality-label">Best Quality (Auto)</span>
                                <span class="quality-desc">MP4 • Highest available</span>
                            </label>
                        </div>
                        
                        <div class="quality-option">
                            <input type="radio" id="quality-1080" name="quality" value="1080">
                            <label for="quality-1080">
                                <span class="quality-label">Full HD</span>
                                <span class="quality-desc">MP4 • 1080p</span>
                            </label>
                        </div>
                        
                        <div class="quality-option">
                            <input type="radio" id="quality-720" name="quality" value="720">
                            <label for="quality-720">
                                <span class="quality-label">HD</span>
                                <span class="quality-desc">MP4 • 720p</span>
                            </label>
                        </div>
                        
                        <button type="submit" name="type" value="video" class="download-btn video-btn">
                            <i class="fas fa-download"></i> Download Video
                        </button>
                    </div>
                </div>
                
                <!-- Audio Download Options -->
                <div class="option-group">
                    <h2><i class="fas fa-music"></i> Audio Downloads</h2>
                    
                    <div class="quality-options">
                        <div class="quality-option">
                            <input type="radio" id="audio-best" name="audio_quality" value="best" checked>
                            <label for="audio-best">
                                <span class="quality-label">Best Quality</span>
                                <span class="quality-desc">MP3 • 320kbps</span>
                            </label>
                        </div>
                        
                        <div class="quality-option">
                            <input type="radio" id="audio-medium" name="audio_quality" value="medium">
                            <label for="audio-medium">
                                <span class="quality-label">Medium Quality</span>
                                <span class="quality-desc">MP3 • 192kbps</span>
                            </label>
                        </div>
                        
                        <button type="submit" name="type" value="audio" class="download-btn audio-btn">
                            <i class="fas fa-download"></i> Download Audio
                        </button>
                    </div>
                </div>
            </form>
            
            <div class="additional-options">
                <a href="index.php" class="back-btn">
                    <i class="fas fa-arrow-left"></i> Download Another Video
                </a>
            </div>
        </div>
    </div>
</div>

<style>
.download-container {
    max-width: 1200px;
    margin: 2rem auto;
    padding: 0 1rem;
}

.video-info {
    display: flex;
    flex-wrap: wrap;
    gap: 2rem;
    background: #fff;
    border-radius: 8px;
    padding: 2rem;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.thumbnail-container {
    flex: 1;
    min-width: 300px;
    position: relative;
    border-radius: 8px;
    overflow: hidden;
}

.video-thumbnail {
    width: 100%;
    height: auto;
    display: block;
    transition: transform 0.3s ease;
}

.thumbnail-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0,0,0,0.3);
    display: flex;
    align-items: center;
    justify-content: center;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.thumbnail-overlay i {
    color: white;
    font-size: 3rem;
}

.thumbnail-container:hover .thumbnail-overlay {
    opacity: 1;
}

.thumbnail-container:hover .video-thumbnail {
    transform: scale(1.02);
}

.download-options {
    flex: 1;
    min-width: 300px;
}

.download-options h1 {
    margin-top: 0;
    color: #333;
    font-size: 1.5rem;
}

.option-group {
    margin-bottom: 2rem;
}

.option-group h2 {
    margin: 0 0 1rem 0;
    color: #333;
    font-size: 1.2rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.quality-options {
    margin: 1rem 0;
}

.quality-option {
    margin: 0.5rem 0;
}

.quality-option input[type="radio"] {
    display: none;
}

.quality-option label {
    display: block;
    padding: 0.8rem 1rem;
    border-radius: 6px;
    cursor: pointer;
    transition: all 0.2s ease;
    border: 1px solid #e0e0e0;
    background: #f9f9f9;
}

.quality-option input[type="radio"]:checked + label {
    border-color: #4285f4;
    background-color: #f0f7ff;
}

.quality-label {
    display: block;
    font-weight: 500;
    color: #333;
}

.quality-desc {
    display: block;
    font-size: 0.9rem;
    color: #666;
}

.download-btn {
    width: 100%;
    padding: 0.8rem;
    border: none;
    border-radius: 6px;
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: background-color 0.2s ease;
    margin-top: 1rem;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
}

.video-btn {
    background-color: #ff0000;
    color: white;
}

.video-btn:hover {
    background-color: #e60000;
}

.audio-btn {
    background-color: #4285f4;
    color: white;
}

.audio-btn:hover {
    background-color: #3367d6;
}

.back-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.6rem 1rem;
    color: #333;
    text-decoration: none;
    border-radius: 6px;
    transition: background-color 0.2s ease;
    border: 1px solid #ddd;
    margin-top: 1rem;
}

.back-btn:hover {
    background-color: #f5f5f5;
}

@media (max-width: 768px) {
    .video-info {
        flex-direction: column;
    }
    
    .thumbnail-container {
        max-width: 100%;
    }
}
</style>
document.querySelector('form').addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const form = this;
    const submitBtn = form.querySelector('button[type="submit"]');
    const originalBtnText = submitBtn.innerHTML;
    
    // Show loading state
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing...';
    
    try {
        const response = await fetch(form.action, {
            method: 'POST',
            body: new FormData(form)
        });
        
        const data = await response.json();
        
        if (data.status === 'success') {
            // Create a temporary iframe for downloading
            if (data.download_url) {
                const iframe = document.createElement('iframe');
                iframe.style.display = 'none';
                iframe.src = data.download_url;
                document.body.appendChild(iframe);
                
                // Show success message
                alert('Your download should start shortly. If it doesn\'t, please try again.');
            } else {
                // For direct downloads (when implemented)
                const a = document.createElement('a');
                a.href = 'download_video.php?' + new URLSearchParams({
                    url: form.querySelector('input[name="url"]').value,
                    type: form.querySelector('input[name="type"]').value,
                    video_id: form.querySelector('input[name="video_id"]').value
                });
                a.click();
            }
            
            // Redirect to success page
            window.location.href = 'download_success.php?type=' + encodeURIComponent(data.type);
            
        } else {
            alert('Error: ' + (data.error || 'Unknown error occurred'));
        }
    } catch (error) {
        console.error('Error:', error);
        alert('Network error. Please try again.');
    } finally {
        submitBtn.disabled = false;
        submitBtn.innerHTML = originalBtnText;
    }
});
document.querySelector('form').addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const form = this;
    const submitBtn = form.querySelector('button[type="submit"]');
    const originalBtnText = submitBtn.innerHTML;
    
    // Show loading state
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing...';
    
    try {
        const formData = new FormData(form);
        const response = await fetch('process_download.php', {
            method: 'POST',
            body: formData
        });
        
        const data = await response.json();
        
        if (data.success) {
            if (data.downloadUrl) {
                // Create hidden iframe for download
                const iframe = document.createElement('iframe');
                iframe.style.display = 'none';
                iframe.src = data.downloadUrl;
                document.body.appendChild(iframe);
                
                // Show success message
                alert('Your download should start shortly. If not, click OK to try again.');
            }
        } else {
            alert('Error: ' + (data.error || 'Download failed'));
        }
    } catch (error) {
        console.error('Error:', error);
        alert('Network error. Please try again.');
    } finally {
        submitBtn.disabled = false;
        submitBtn.innerHTML = originalBtnText;
    }
});
<?php include 'footer.php'; ?>