<?php
// Set SEO title, meta description, and meta keywords for the About Us page
$seoTitle = 'About Us - YTDL.online';
$metaDescription = 'Learn more about YTDL.online, our mission, and how we provide a simple, reliable YouTube video downloader service.';
$metaKeywords = 'about YTDL.online, YTDL downloader, video downloader, youtube downloader, download videos';

// Sanitize output to prevent XSS attacks
$seoTitle = htmlspecialchars($seoTitle, ENT_QUOTES, 'UTF-8');
$metaDescription = htmlspecialchars($metaDescription, ENT_QUOTES, 'UTF-8');
$metaKeywords = htmlspecialchars($metaKeywords, ENT_QUOTES, 'UTF-8');

// Include the header (assuming it's a part of the template with meta, stylesheet links, etc.)
include 'header.php';
?>

<!-- Head section with SEO and CSS -->
<head>
    <meta name="robots" content="index, follow">
    <meta name="description" content="<?php echo $metaDescription; ?>">
    <meta name="keywords" content="<?php echo $metaKeywords; ?>">
    <title><?php echo $seoTitle; ?></title>

    <!-- Link to compiled CSS file -->
    <link rel="stylesheet" href="/styles.css"> <!-- Ensure this path is correct -->
</head>

<!-- Main Content -->
<div class="container">
    <!-- About Us Section -->
    <div class="about-us-section">
        <h1><?php echo $seoTitle; ?></h1>
        <p class="tagline">Discover the story behind YTDL.online and our commitment to providing a seamless YouTube video download experience.</p>

        <div class="about-us-content">
            <h2>Our Mission</h2>
            <p>At <strong>YTDL.online</strong>, our mission is simple: to provide users with a fast, easy, and reliable way to download YouTube videos in various formats such as MP4, MP3, and more. We understand that sometimes you need to save content offline for convenience or enjoyment, and we strive to make that process as smooth as possible.</p>

            <h3>Who We Are</h3>
            <p><strong>YTDL.online</strong> is a user-friendly web app that allows anyone to easily download their favorite videos from YouTube, whether it's for educational purposes, offline viewing, or personal enjoyment. Our service does not require any software installation or technical knowledge—just visit our site, paste the video URL, and download in your preferred format!</p>

            <h3>Why YTDL.online?</h3>
            <p>We believe that downloading videos should be straightforward and accessible to everyone. That's why we built <strong>YTDL.online</strong> with the following goals in mind:</p>
            <ul>
                <li><strong>Ease of Use:</strong> Our website is designed to be as simple and intuitive as possible. You don't need any technical expertise to use our platform.</li>
                <li><strong>Fast Downloads:</strong> We aim to provide high-speed downloads so you can get your videos quickly and without hassle.</li>
                <li><strong>Wide Format Support:</strong> We offer various formats, including MP4 and MP3, to cater to different user needs. Whether you're downloading a video or an audio file, we’ve got you covered.</li>
                <li><strong>Privacy and Security:</strong> Your privacy is important to us. We don't collect personal data for our video downloading service and ensure your safety while using our platform.</li>
                <li><strong>Free Service:</strong> YTDL.online is entirely free to use. We believe everyone should have access to a reliable video downloader without any hidden costs or subscriptions.</li>
            </ul>

            <h3>Our Brand Name: YTDL.online</h3>
            <p>The name "YTDL" stands for **YouTube Downloader**, and it perfectly reflects the core of our service—making YouTube video downloads easy and accessible. The ".online" domain emphasizes that our service is entirely web-based, accessible from anywhere, and doesn't require software installation or downloads from other platforms. We want to make it as convenient as possible for users to access and save their favorite YouTube videos with just a few clicks.</p>

            <h3>Our Commitment</h3>
            <p>At YTDL.online, we are committed to delivering a high-quality, ad-free, and seamless experience to all our users. We constantly strive to improve our service by adding new features and ensuring that it is accessible to people from all around the world.</p>

            <h3>Contact Us</h3>
            <p>If you have any questions, feedback, or inquiries about our services, feel free to reach out to us:</p>
            <p><strong>Email:</strong> <a href="mailto:support@ytdl.online">support@ytdl.online</a></p>

            <p>We value your feedback and are always open to suggestions to make YTDL.online even better!</p>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
