<?php
if (isset($_GET['url'], $_GET['type'])) {
    $videoUrl = urldecode($_GET['url']);
    $type = $_GET['type']; // 'video' or 'audio'
    $quality = isset($_GET['quality']) ? $_GET['quality'] : 'best'; // Default to 'best' quality

    // Escape the URL for shell safety
    $escapedUrl = escapeshellarg($videoUrl);

    // Set headers for download
    if ($type == 'audio') {
        // Audio download (MP3)
        header('Content-Type: audio/mpeg');
        header('Content-Disposition: attachment; filename="audio.mp3"');
        $downloadCommand = "yt-dlp -f bestaudio --extract-audio --audio-format mp3 -o - {$escapedUrl}";
    } else {
        // Video download (MP4 with video and audio)
        header('Content-Type: video/mp4');
        header('Content-Disposition: attachment; filename="video.mp4"');
        // Set the quality based on user selection
        if ($quality == '720p') {
            $downloadCommand = "yt-dlp -f 'bestaudio[ext=m4a]+bestvideo[height<=720]' -o - {$escapedUrl}";
        } elseif ($quality == '1080p') {
            $downloadCommand = "yt-dlp -f 'bestaudio[ext=m4a]+bestvideo[height<=1080]' -o - {$escapedUrl}";
        } elseif ($quality == '480p') {
            $downloadCommand = "yt-dlp -f 'bestaudio[ext=m4a]+bestvideo[height<=480]' -o - {$escapedUrl}";
        } else {
            $downloadCommand = "yt-dlp -f 'bestvideo+bestaudio' -o - {$escapedUrl}";
        }
    }

    // Execute the yt-dlp command and stream the content to the user
    $process = popen($downloadCommand, 'r');

    if ($process) {
        while (!feof($process)) {
            echo fread($process, 1024 * 8); // Output in chunks of 8KB
            ob_flush(); // Flush the output buffer to the browser
            flush();    // Ensure immediate output
        }
        fclose($process);
    } else {
        echo "Error: Failed to fetch the video or audio.";
    }

    exit();
} else {
    echo "Error: Invalid parameters.";
}
