<?php
if (isset($_GET['url'])) {
    $videoUrl = $_GET['url']; // Get the video URL

    // More comprehensive YouTube URL validation regex (for multiple URL types)
    $regex = '/^(https?:\/\/)?(www\.)?(youtube|youtu|youtube-nocookie)\.(com|be)\/(watch\?v=[a-zA-Z0-9_-]+|playlist\?list=[a-zA-Z0-9_-]+|.*)$/';

    // Validate the YouTube URL using the regex
    if (preg_match($regex, $videoUrl)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'errorMessage' => 'Invalid YouTube URL.']);
    }
} else {
    echo json_encode(['success' => false, 'errorMessage' => 'No URL provided.']);
}
?>
