<?php
// Set SEO title, meta description, and meta keywords for YouTube downloader
$seoTitle = 'Download YouTube Videos Online - YTDL'; 
$seoTitle = htmlspecialchars($seoTitle, ENT_QUOTES, 'UTF-8');
$metaDescription = "Download YouTube videos in various formats and resolutions easily with our online tool.";
$metaDescription = htmlspecialchars($metaDescription, ENT_QUOTES, 'UTF-8');
$metaKeywords = "download youtube videos, youtube video downloader, download videos, youtube mp4, youtube download tool";
$metaKeywords = htmlspecialchars($metaKeywords, ENT_QUOTES, 'UTF-8');

// Include the header (assuming it's a part of the template with meta, stylesheet links, etc.)
include 'header.php';
?>

<head>
    <meta name="robots" content="index, follow">
    <meta name="description" content="<?php echo $metaDescription; ?>">
    <meta name="keywords" content="<?php echo $metaKeywords; ?>">
    <title><?php echo $seoTitle; ?></title>

    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <link rel="stylesheet" href="path/to/your/styles.css">
</head>

<div class="container">
    <div class="result-container"></div> 

    <div class="form-column">
        <h1 id="pageTitle"><?php echo $seoTitle; ?></h1>
        <p id="tagline" class="tagline">Download YouTube videos in high-quality MP4, MP3, and more formats.</p>

        <div id="formContainer" class="form-container">
            <!-- Form that will submit the YouTube URL for fetching the video -->
            <form id="videoForm">
                <label for="youtubeUrl" class="url-label">Enter YouTube Video URL</label>
                <input type="url" name="url" id="youtubeUrl" placeholder="https://www.youtube.com/watch?v=example" required>
                <button type="submit" class="submit-btn">Fetch Video</button>
            </form>
        </div>
    </div>
</div>

<script type="text/javascript">
    window.onload = function() {
        const form = document.getElementById('videoForm');
        const submitButton = document.querySelector('.submit-btn');
        const resultContainer = document.querySelector('.result-container');
        const urlInput = document.getElementById('youtubeUrl');

        form.addEventListener('submit', function(event) {
            event.preventDefault(); // Prevent the default form submission

            submitButton.textContent = 'Fetching Download Link...'; // Change button text
            submitButton.disabled = true; // Disable the button

            const youtubeUrl = document.getElementById('youtubeUrl').value;

            // Send the request to fetch the video link
            fetch('fetch_video.php?url=' + encodeURIComponent(youtubeUrl))
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Redirect to thankyou.php with the video URL
                        window.location.href = 'thankyou.php?url=' + encodeURIComponent(youtubeUrl);
                    } else {
                        resultContainer.innerHTML = `<h3>Error: ${data.errorMessage}</h3>`;
                    }
                })
                .catch(error => {
                    console.error('Error fetching video:', error);
                    resultContainer.innerHTML = '<h3>There was an error processing your request.</h3>';
                });
        });
    };
</script>
