<?php
// Set SEO title, meta description, and meta keywords for the News page
$seoTitle = 'News - YTDL.online';
$metaDescription = 'Stay up-to-date with the latest news, updates, and blog posts from YTDL.online. Learn about new features, improvements, and YouTube downloading tips.';
$metaKeywords = 'news, YTDL.online, blog, updates, youtube downloader news, video downloader news';

// Sanitize output to prevent XSS attacks
$seoTitle = htmlspecialchars($seoTitle, ENT_QUOTES, 'UTF-8');
$metaDescription = htmlspecialchars($metaDescription, ENT_QUOTES, 'UTF-8');
$metaKeywords = htmlspecialchars($metaKeywords, ENT_QUOTES, 'UTF-8');

// Include the header and footer
include 'header.php';
?>

<!-- Head section with SEO and CSS -->
<head>
    <meta name="robots" content="index, follow">
    <meta name="description" content="<?php echo $metaDescription; ?>">
    <meta name="keywords" content="<?php echo $metaKeywords; ?>">
    <title><?php echo $seoTitle; ?></title>

    <!-- Link to compiled CSS file -->
    <link rel="stylesheet" href="/styles.css"> <!-- Ensure this path is correct -->
    
    <style>
        /* Night Mode Styles */
        body {
            background-color: #121212; /* Dark background */
            color: #e0e0e0; /* Light text */
            font-family: 'Arial', sans-serif;
        }

        .news-section {
            margin-top: 20px;
            padding: 20px;
            background-color: #1e1e1e; /* Darker background for the section */
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.3);
        }

        .news-section h1 {
            font-size: 32px;
            font-weight: bold;
            color: #ffffff; /* White text for title */
            margin-bottom: 10px;
        }

        .news-section .tagline {
            font-size: 18px;
            color: #cccccc; /* Lighter color for tagline */
            margin-bottom: 30px;
        }

        .news-content {
            display: flex;
            flex-direction: column;
        }

        .post {
            background-color: #333333; /* Dark gray background for posts */
            padding: 20px;
            margin-bottom: 20px;
            border: 1px solid #444444; /* Slightly lighter border */
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.5);
        }

        .post h2 {
            font-size: 24px;
            font-weight: bold;
            color: red; 
            margin-bottom: 10px;
            transition: color 0.3s ease;
        }

        .post h2 a {
            color: inherit;
            text-decoration: none;
        }

        .post h2 a:hover {
            color: darkred; 
        }

        .post .post-meta {
            font-size: 12px;
            color: #888888; /* Light gray for meta info */
            margin-bottom: 15px;
            text-align: right; /* Position the date on the right */
        }

        .post p {
            font-size: 16px;
            color: #e0e0e0; /* Light text for body content */
            line-height: 1.6;
            margin-bottom: 15px;
        }

        .post .read-more {
            font-size: 14px;
            color: red; 
            text-decoration: none;
        }

        .post .read-more:hover {
            text-decoration: underline;
        }

        /* Additional styling for links and other elements */
        a {
            color: red; 
            text-decoration: none;
        }

        a:hover {
            color: white;
            text-decoration: underline;
        }
    </style>
</head>

<!-- Main Content -->
<div class="container">
    <!-- News Section -->
    <div class="news-section">
        <h1><?php echo $seoTitle; ?></h1>
        <p class="tagline">Get the latest updates, news, and insights from YTDL.online!</p>

        <div class="news-content">
            <!-- Dummy Blog Posts -->
            <div class="post">
                <h2><a href="#">Introducing MP3 Audio Downloads for YouTube Videos</a></h2>
                <p class="post-meta">Posted on November 20, 2024 by <strong>YTDL Team</strong></p>
                <p>We're excited to introduce a new feature on YTDL.online: You can now download YouTube videos as MP3 audio files! This is perfect for music lovers who want to enjoy their favorite YouTube content offline in audio format.</p>
                <a href="#" class="read-more">Read more...</a>
            </div>

            <div class="post">
                <h2><a href="#">YTDL.online Now Supports 4K Video Downloads!</a></h2>
                <p class="post-meta">Posted on November 10, 2024 by <strong>YTDL Team</strong></p>
                <p>We’ve expanded our video quality options! YTDL.online now supports 4K video downloads. Whether you're downloading movies or high-definition content, you can enjoy your videos in ultra-high quality.</p>
                <a href="#" class="read-more">Read more...</a>
            </div>

            <div class="post">
                <h2><a href="#">New User Interface Update for a Sleek Experience</a></h2>
                <p class="post-meta">Posted on October 15, 2024 by <strong>YTDL Team</strong></p>
                <p>We've updated our user interface to make YTDL.online even easier to use. The new design is cleaner, faster, and more intuitive, ensuring a better experience when downloading YouTube videos.</p>
                <a href="#" class="read-more">Read more...</a>
            </div>

            <div class="post">
                <h2><a href="#">How to Download YouTube Playlists in Bulk</a></h2>
                <p class="post-meta">Posted on October 1, 2024 by <strong>YTDL Team</strong></p>
                <p>If you’ve ever wanted to download entire YouTube playlists, now you can! This blog post walks you through the steps to efficiently download multiple videos from a playlist with YTDL.online.</p>
                <a href="#" class="read-more">Read more...</a>
            </div>

            <div class="post">
                <h2><a href="#">YTDL.online Now Available on Mobile Devices</a></h2>
                <p class="post-meta">Posted on September 25, 2024 by <strong>YTDL Team</strong></p>
                <p>Good news for mobile users! YTDL.online is now fully optimized for mobile devices, allowing you to download YouTube videos on-the-go from your smartphone or tablet.</p>
                <a href="#" class="read-more">Read more...</a>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
