<?php
// Set SEO title, meta description, and meta keywords for the Privacy Policy page
$seoTitle = 'Privacy Policy - YTDL.online';
$metaDescription = 'Read our Privacy Policy to understand how we collect, use, and protect your data when using YTDL.online.';
$metaKeywords = 'privacy policy, YTDL.online, data protection, youtube downloader, user privacy, GDPR';

// Sanitize output to prevent XSS attacks
$seoTitle = htmlspecialchars($seoTitle, ENT_QUOTES, 'UTF-8');
$metaDescription = htmlspecialchars($metaDescription, ENT_QUOTES, 'UTF-8');
$metaKeywords = htmlspecialchars($metaKeywords, ENT_QUOTES, 'UTF-8');

// Include the header (assuming it's a part of the template with meta, stylesheet links, etc.)
include 'header.php';
?>

<!-- Head section with SEO and CSS -->
<head>
    <meta name="robots" content="index, follow">
    <meta name="description" content="<?php echo $metaDescription; ?>">
    <meta name="keywords" content="<?php echo $metaKeywords; ?>">
    <title><?php echo $seoTitle; ?></title>

    <!-- Link to compiled CSS file -->
    <link rel="stylesheet" href="/styles.css"> <!-- Ensure this path is correct -->
</head>

<!-- Main Content -->
<div class="container">
    <!-- Privacy Policy Section -->
    <div class="privacy-policy-section">
        <h1><?php echo $seoTitle; ?></h1>
        <p class="tagline">Learn how we protect your privacy and handle your data securely.</p>

        <div class="privacy-policy-content">
            <h2>Introduction</h2>
            <p>At <strong>YTDL.online</strong>, your privacy is important to us. This Privacy Policy outlines how we collect, use, and protect your personal data when you use our services.</p>

            <h3>Information We Collect</h3>
            <p>We collect information to provide and improve our services. The types of information we collect include:</p>
            <ul>
                <li><strong>Personal Information:</strong> We do not collect personal information unless provided voluntarily (e.g., contact via email). We do not require any personal data for video downloading.</li>
                <li><strong>Usage Data:</strong> Information about how you use our website, including IP address, browser type, device information, and pages visited.</li>
                <li><strong>Cookies:</strong> We use cookies to enhance your user experience. Cookies help us analyze usage patterns, and you can control their settings via your browser.</li>
            </ul>

            <h3>How We Use Your Information</h3>
            <p>The information we collect is used for the following purposes:</p>
            <ul>
                <li>To operate and improve our website and services.</li>
                <li>To analyze user interactions to improve the performance and user experience.</li>
                <li>To ensure compliance with applicable legal obligations.</li>
            </ul>

            <h3>How We Protect Your Information</h3>
            <p>We take your privacy seriously and use a combination of technical and organizational measures to protect your data:</p>
            <ul>
                <li>Data encryption during transmission to protect sensitive information.</li>
                <li>Use of secure servers and firewalls to prevent unauthorized access.</li>
                <li>Regular security audits and updates to safeguard your data.</li>
            </ul>

            <h3>Your Rights</h3>
            <p>As a user of YTDL.online, you have the following rights regarding your personal information:</p>
            <ul>
                <li><strong>Access:</strong> You can request access to the personal data we may hold about you.</li>
                <li><strong>Correction:</strong> You can request corrections to any inaccurate or incomplete information.</li>
                <li><strong>Deletion:</strong> You may request the deletion of your personal data, subject to certain legal limitations.</li>
                <li><strong>Opt-Out:</strong> You can opt-out of receiving marketing or promotional communications.</li>
            </ul>

            <h3>Cookies and Tracking</h3>
            <p>We use cookies and other tracking technologies to provide a better user experience, monitor usage, and improve our services. You can adjust your browser settings to manage cookies. However, disabling cookies may affect your ability to use certain features of our site.</p>

            <h3>Changes to This Privacy Policy</h3>
            <p>We may update this Privacy Policy from time to time to reflect changes in our practices. Any updates will be posted on this page, along with the revised date of the policy. Please review this policy regularly to stay informed about how we are protecting your data.</p>

            <h3>Contact Us</h3>
            <p>If you have any questions about this Privacy Policy or how we handle your data, please contact us:</p>
            <p><strong>Email:</strong> <a href="mailto:support@ytdl.online">support@ytdl.online</a></p>

            <p>We value your privacy and are here to help with any questions you may have!</p>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
