<?php
if (isset($_GET['url'])) {
    $url = $_GET['url'];
    // Validate the URL server-side (important!)
    if (!preg_match('/^(https?:\/\/(www\.)?(youtube\.com|youtu\.be)\/((watch\?v=)|(embed\/))([a-zA-Z0-9_-]{11,})|https?:\/\/youtube\.com\/playlist\?list=[a-zA-Z0-9_-]+)$/', $url)) {
        echo json_encode(['error' => 'Invalid YouTube URL.']);
        exit;
    }

    // Use yt-dlp (or youtube-dl) to get video information safely
    $command = "yt-dlp -j " . escapeshellarg($url); // -j for JSON output
    $output = shell_exec($command);
    $data = json_decode($output, true);

    if ($data) {
        //  Important:  Sanitize the data before sending it to the client!
        $sanitized_data = [
            'title' => htmlspecialchars($data['title'], ENT_QUOTES, 'UTF-8'),
            'formats' => array_map(function($format) {
                return [
                    'url' => htmlspecialchars($format['url'], ENT_QUOTES, 'UTF-8'),
                    'ext' => htmlspecialchars($format['ext'], ENT_QUOTES, 'UTF-8'),
                    'mime_type' => htmlspecialchars($format['mime_type'], ENT_QUOTES, 'UTF-8'),
                    'quality_label' => isset($format['quality_label']) ? htmlspecialchars($format['quality_label'], ENT_QUOTES, 'UTF-8') : null,
                    'height' => isset($format['height']) ? intval($format['height']) : null,
                    'audio_quality' => isset($format['audio_quality']) ? htmlspecialchars($format['audio_quality'], ENT_QUOTES, 'UTF-8') : null,
                    'content_length' => isset($format['filesize']) ? intval($format['filesize']) : null,
                ];
            }, $data['formats'])
        ];
        echo json_encode($sanitized_data);

    } else {
        echo json_encode(['error' => 'Failed to retrieve video information.']);
    }
} else {
    echo json_encode(['error' => 'No URL provided.']);
}
?>