<?php
// Ensure the 'url' parameter is provided
if (isset($_GET['url'])) {
    $videoUrl = urldecode($_GET['url']); // Get the decoded video URL
} else {
    echo "Error: No URL provided.";
    exit();
}

// Include the header (this will load the header, meta tags, and styles from your existing header.php)
include 'header.php';
?>

<div class="container">
    <div class="result-container">
        <!-- Video download options -->
        <h1>Choose Your Download Option</h1>
        <p>Video URL: <?php echo htmlspecialchars($videoUrl); ?></p>

        <!-- Download Form -->
        <form action="download_video.php" method="get">
            <input type="hidden" name="url" value="<?php echo htmlspecialchars($videoUrl); ?>">

            <!-- Download Video Section -->
            <div class="download-buttons">
                <label for="videoQuality">Select Video Quality:</label>
                <select id="videoQuality" name="quality" class="select-quality">
                    <option value="best" selected>Best Quality (Auto)</option>
                    <option value="720p">720p</option>
                    <option value="1080p">1080p</option>
                    <option value="480p">480p</option>
                </select>
                <button type="submit" class="btn download-btn" name="type" value="video" id="downloadVideoBtn">
                    Download Video
                </button>
            </div>

            <!-- Audio Download Button -->
            <div class="download-buttons">
                <button type="submit" class="btn download-btn" name="type" value="audio">
                    Download Audio (MP3)
                </button>
            </div>

            <!-- Reload or Download More Videos -->
            <div class="download-buttons">
                <a href="/" class="btn btn-download-again" style="background-color: #FF0000;">
                    <img src="/assets/reload.svg" alt="Reload icon" class="download-icon">
                    Download More Videos
                </a>
            </div>
        </form>
    </div>
</div>
<style>
    /* Style for the download buttons */
.btn.download-btn {
    background-color: #28a745; /* Green button color */
    color: white;
    padding: 12px 20px;
    border: none;
    border-radius: 5px;
    font-size: 16px;
    cursor: pointer;
    margin: 5px 0;
    width: 100%;
    text-align: center;
    transition: background-color 0.3s ease;
}

.btn.download-btn:hover {
    background-color: #218838; /* Darker green on hover */
}

/* Style for the dropdown */
.dropdown {
    margin: 20px 0;
    display: flex;
    flex-direction: column;
}

.dropdown label {
    font-size: 16px;
    margin-bottom: 5px;
}

.select-quality {
    padding: 12px;
    font-size: 16px;
    width: 100%;
    border-radius: 5px;
    border: 1px solid #ccc;
    background-color: #f9f9f9;
    cursor: pointer;
}

/* Style for the container */
.container {
    width: 90%;
    max-width: 600px;
    margin: 0 auto;
    padding: 20px;
    text-align: center;
}

/* Additional spacing */
.result-container {
    margin-top: 20px;
}

</style>
<!-- Include the footer -->
<?php
include 'footer.php';
?>
