<?php

// Allowed file extensions
$allowedExtensions = ['doc', 'docx', 'pdf', 'zip', 'ppt', 'svg'];  // Include new formats

// Check if file is uploaded
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['fileToCorrupt'])) {
    $file = $_FILES['fileToCorrupt'];

    // Get the file extension
    $fileExtension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));

    // Check if file extension is allowed
    if (in_array($fileExtension, $allowedExtensions)) {
        $fileTmpName = $file['tmp_name'];
        $fileName = $file['name'];
        
        // Define the corrupted file path and keep the original name
        $corruptedFilePath = 'uploads/' . $fileName;

        // Ensure the uploads directory exists
        if (!is_dir('uploads')) {
            mkdir('uploads', 0777, true);
        }

        // Read the file content
        $fileContent = file_get_contents($fileTmpName);
        $fileSize = strlen($fileContent);

        // Create random corruption data
        $corruptionFactor = 512; // The number of bytes to corrupt
        $corruption = random_bytes($corruptionFactor);  // Create random corruption data

        // 1. Modify the first 512 bytes (header)
        $fileContent = substr_replace($fileContent, $corruption, 0, $corruptionFactor);

        // 2. Modify a random section in the middle (e.g., 1024 bytes after 25% of the file)
        $midCorruptionPosition = $fileSize / 4;
        $fileContent = substr_replace($fileContent, $corruption, $midCorruptionPosition, $corruptionFactor);

        // 3. Corrupt the footer (last 512 bytes)
        $footerCorruptionPosition = $fileSize - $corruptionFactor;
        $fileContent = substr_replace($fileContent, $corruption, $footerCorruptionPosition, $corruptionFactor);

        // Save the corrupted file with the same name
        if (file_put_contents($corruptedFilePath, $fileContent)) {
            // Redirect to the result page with success status
            header("Location: index.php?result=success&file=$fileName");
            exit;
        } else {
            // Redirect to the result page with error status
            header("Location: index.php?result=error");
            exit;
        }
    } else {
        // Redirect to the result page with error status
        header("Location: index.php?result=error");
        exit;
    }
}

?>
