<?php
// Get the video file name from the query string (e.g., 'file' parameter in the URL)
if (isset($_GET['file'])) {
    // Sanitize the filename to prevent directory traversal attacks
    $file = basename($_GET['file']); 

    // Define the path to the video file (change this path according to your setup)
    $filePath = 'downloads/' . $file;  // Ensure this path is correct

    // Check if the file exists
    if (file_exists($filePath)) {
        // Set the appropriate headers for downloading the file
        header('Content-Description: File Transfer');
        header('Content-Type: video/mp4'); // Adjust the MIME type if the video is not MP4
        header('Content-Disposition: attachment; filename="' . basename($filePath) . '"');
        header('Content-Transfer-Encoding: binary');
        header('Content-Length: ' . filesize($filePath));
        flush(); // Flush system output buffer

        // Read the file and output it to the browser
        readfile($filePath);
        exit;
    } else {
        // Handle case where the file does not exist
        echo 'File not found.';
    }
} else {
    // If no file parameter is provided, show an error
    echo 'No file specified.';
}
