<?php
if (isset($_GET['url'])) {
    $videoUrl = urldecode($_GET['url']); // Get the decoded video URL

    // Set headers to force download the video
    header('Content-Type: application/octet-stream');
    header('Content-Disposition: attachment; filename="downloaded_video.mp4"'); // You can set a fixed filename or parse the title if needed
    header('Content-Transfer-Encoding: binary');
    header('Cache-Control: no-cache');
    header('Pragma: no-cache');

    // Escape the URL to prevent shell injection
    $escapedUrl = escapeshellarg($videoUrl);

    // Use yt-dlp to download the best available video format with audio in one file
    $downloadCommand = "yt-dlp -f best -o - {$escapedUrl}";  // The 'best' option downloads the best video with audio in one file

    // Open the process to stream the video
    $process = popen($downloadCommand, 'r');

    if ($process) {
        while (!feof($process)) {
            echo fread($process, 1024 * 8); // Output in chunks of 8KB
            ob_flush(); // Flush the output buffer to the browser
            flush();    // Ensure immediate output
        }
        fclose($process);
    } else {
        echo "Error: Failed to fetch the video.";
    }

    exit();
} else {
    echo "Error: Invalid video URL.";
}
?>
