<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
       <meta name="robots" content="noindex, nofollow, noarchive">

    <link rel="canonical" href="https://<?php echo $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>" />
    <!-- Favicon -->
    <link rel="icon" href="/assets/favicon.svg" type="image/svg+xml">

    <!-- Ensure the correct relative path to your CSS -->
    <link rel="stylesheet" href="/styles.css"> <!-- Adjust the CSS path as needed -->
</head>
<body>

<!-- Header Section -->
<header class="header">
    <!-- Logo Section -->
    <div class="logo">
        <a href="/"><img src="/assets/logo.svg" alt="YTDL Online" style="height: 50px; object-fit: contain;"></a>
    </div>

    <!-- Language Switcher Dropdown -->
<!-- Language Switcher -->
<div class="language-switcher">
    <select id="language-select" name="language" onchange="changeLanguage()" style="background-color: #333; color: #f4f4f9; border: none; padding: 8px 12px; font-size: 16px; border-radius: 5px; cursor: pointer;">
        <!-- English (🇺🇸 Emoji) -->
        <option value="en" data-flag="🇺🇸" <?php echo (basename($_SERVER['REQUEST_URI'], ".php") == 'en' || basename($_SERVER['REQUEST_URI'], ".php") == '') ? 'selected' : ''; ?>>
            🇺🇸 English
        </option>
        
        <!-- Spanish (🇪🇸 Emoji) -->
        <option value="es" data-flag="🇪🇸" <?php echo (basename($_SERVER['REQUEST_URI'], ".php") == 'es') ? 'selected' : ''; ?>>
            🇪🇸 Spanish
        </option>
        
        <!-- French (🇫🇷 Emoji) -->
        <option value="fr" data-flag="🇫🇷" <?php echo (basename($_SERVER['REQUEST_URI'], ".php") == 'fr') ? 'selected' : ''; ?>>
            🇫🇷 French
        </option>
        
        <!-- Portuguese (🇵🇹 Emoji) -->
        <option value="pt" data-flag="🇵🇹" <?php echo (basename($_SERVER['REQUEST_URI'], ".php") == 'pt') ? 'selected' : ''; ?>>
            🇵🇹 Portuguese
        </option>
        
        <!-- Italian (🇮🇹 Emoji) -->
        <option value="it" data-flag="🇮🇹" <?php echo (basename($_SERVER['REQUEST_URI'], ".php") == 'it') ? 'selected' : ''; ?>>
            🇮🇹 Italian
        </option>
    </select>
</div>

<!-- JavaScript to Handle Language Switching -->
<script type="text/javascript">
    function changeLanguage() {
        var lang = document.getElementById('language-select').value;  // Get the selected language
        var currentUrl = window.location.pathname;  // Get the current URL path

        // Redirect to the relevant language page
        if (lang === 'en') {
            window.location.href = '/';  // For English, redirect to homepage ("/")
        } else {
            // Check if language-specific page already exists (like "/fr" for French)
            if (currentUrl.includes('/' + lang)) {
                window.location.reload();  // If already on the correct language page, reload
            } else {
                window.location.href = '/' + lang;  // Otherwise, go to the relevant language page
            }
        }
    }
</script>


    </div>
</header>

<!-- Main Content Begins -->
<main>
    <!-- Your content here -->
</main>

</body>
</html>
