<?php
// Set SEO title, meta description, and meta keywords for YouTube downloader
$seoTitle = 'Download YouTube Videos Online - YTDL'; // Add YTDL to title
$seoTitle = htmlspecialchars($seoTitle, ENT_QUOTES, 'UTF-8');
$metaDescription = "Download YouTube videos in various formats and resolutions easily with our online tool.";
$metaDescription = htmlspecialchars($metaDescription, ENT_QUOTES, 'UTF-8');
$metaKeywords = "download youtube videos, youtube video downloader, download videos, youtube mp4, youtube download tool";
$metaKeywords = htmlspecialchars($metaKeywords, ENT_QUOTES, 'UTF-8');

// Include the header (assuming it's a part of the template with meta, stylesheet links, etc.)
include 'header.php';
?>

<head>
    <meta name="robots" content="index, follow">
    <meta name="description" content="<?php echo $metaDescription; ?>">
    <meta name="keywords" content="<?php echo $metaKeywords; ?>">
    <title><?php echo $seoTitle; ?></title>

    <!-- Viewport meta tag to prevent zoom on mobile -->
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    
    <!-- Link to your stylesheet -->
    <link rel="stylesheet" href="path/to/your/styles.css">

    <style>
        /* Additional CSS for Input field cursor */
        #youtubeUrl {
            cursor: text; /* This ensures the cursor is 'text' when focusing on the input field */
        }
    </style>
</head>

<div class="container">
    <div class="result-container"></div> <!-- This will display the results of the video fetch -->

    <div class="form-column">
        <h1 id="pageTitle"><?php echo $seoTitle; ?></h1>
        <p id="tagline" class="tagline">Download YouTube videos in high-quality MP4, MP3, and more formats.</p>

        <div id="formContainer" class="form-container">
            <!-- Form that will submit the YouTube URL for fetching the video -->
            <form id="videoForm">
                <label for="youtubeUrl" class="url-label">Enter YouTube Video URL</label>
                <input type="url" name="url" id="youtubeUrl" placeholder="https://www.youtube.com/watch?v=example" required>
                <button type="submit" class="submit-btn">Fetch Video</button>
            </form>
        </div>

        <div class="ad-banner-wrapper">
            <p>Advertisement Placeholder</p>
        </div>
    </div>
</div>

<!-- Footer inclusion (for consistent footer on all pages) -->
<?php include 'footer.php'; ?>

<script type="text/javascript">
    window.onload = function() {
        const form = document.getElementById('videoForm');
        const submitButton = document.querySelector('.submit-btn');
        const resultContainer = document.querySelector('.result-container');
        const urlInput = document.getElementById('youtubeUrl');
        const pageTitle = document.getElementById('pageTitle');
        const tagline = document.getElementById('tagline');
        const formContainer = document.getElementById('formContainer');

        form.addEventListener('submit', function(event) {
            event.preventDefault(); // Prevent the default form submission

            submitButton.textContent = 'Fetching Download Link...'; // Change button text
            submitButton.disabled = true; // Disable the button
            urlInput.style.cursor = 'text'; // Ensure the cursor is text for the URL input field

            const youtubeUrl = document.getElementById('youtubeUrl').value;

            // Send the request to fetch the video link
            fetch('fetch_video.php?url=' + encodeURIComponent(youtubeUrl))
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Hide the form, heading, and tagline
                        pageTitle.style.display = 'none';
                        tagline.style.display = 'none';
                        formContainer.style.display = 'none';

                        resultContainer.innerHTML = ` 
                            <h3>Video fetched successfully!</h3>
                            <p>Click below to download the video:</p>
                            <a href="download_video.php?url=${encodeURIComponent(youtubeUrl)}" class="btn download-btn">
                                <img src="/assets/download.svg" alt="Download icon" class="download-icon">
                                Download Video
                            </a>
                            <a href="/" class="btn btn-download-again" style="background-color: #FF0000;">
                                <img src="/assets/reload.svg" alt="Reload icon" class="download-icon">
                                Download More Videos
                            </a>
                        `;
                    } else {
                        resultContainer.innerHTML = `<h3>Error: ${data.errorMessage}</h3>`;
                    }
                })
                .catch(error => {
                    console.error('Error fetching video:', error);
                    resultContainer.innerHTML = '<h3>There was an error processing your request.</h3>';
                });
        });
    };
</script>
