<?php
// Ensure a URL is provided
if (isset($_GET['url']) && filter_var($_GET['url'], FILTER_VALIDATE_URL)) {
    $youtubeUrl = $_GET['url'];

    // Clean the URL to avoid issues with shell execution
    $youtubeUrl = escapeshellarg($youtubeUrl);

    // Fetch video info (we use yt-dlp to fetch metadata about the video)
    // `-e` flag gets the video title (to use for filename)
    $command = "yt-dlp -e {$youtubeUrl}";

    // Capture the output of the command (video title)
    $videoTitle = shell_exec($command);

    // Clean up the title to avoid issues with filenames (remove special characters)
    $videoTitle = preg_replace('/[^A-Za-z0-9\-]/', '_', trim($videoTitle)); // Replace spaces and special chars with underscores

    if ($videoTitle) {
        // Add prefix to filename
        $finalFileName = "ytdl.online-{$videoTitle}.mp4";

        // Prepare the video download link (actual file location)
        $downloadLink = "/path/to/downloads/{$finalFileName}"; // This should point to where the video will be saved.
    } else {
        $downloadLink = '';
        $errorMsg = 'Unable to fetch video title.';
    }
} else {
    header("Location: index.php?result=error&msg=Invalid+URL");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Thank You - Video Download</title>
    <link rel="stylesheet" href="/styles.css">
</head>
<body>

<div class="container">
    <div class="result-container">
        <?php if (isset($downloadLink) && $downloadLink): ?>
            <h3>Video fetched successfully!</h3>
            <p>Click the button below to start downloading your video:</p>
            <a href="download_video.php?url=<?php echo urlencode($downloadLink); ?>" class="btn download-btn">
                <img src="/assets/download.svg" alt="Download icon" class="download-icon">
                Download Video
            </a>
            <a href="index.php" class="btn btn-download-again" style="background-color: #FF0000;">
                <img src="/assets/reload.svg" alt="Reload icon" class="download-icon">
                Download Another Video
            </a>
        <?php else: ?>
            <h3>Error: <?php echo $errorMsg ?? 'An unknown error occurred.'; ?></h3>
            <a href="index.php" class="btn btn-download-again" style="background-color: #FF0000;">
                <img src="/assets/reload.svg" alt="Reload icon" class="download-icon">
                Try Again
            </a>
        <?php endif; ?>
    </div>
</div>

</body>
</html>
